// shopbot.cpp 
// ackmed@gotwalls.com


#include "shopbot.h"
#include "miscstructs.h"
#include "item.h"
#include "Weapons.h"
#include "packethelper.h"
#include "waypoint.h"
#include "config.h"
#include "external/LinkedList/LinkedList.h"
#include "external/commonstructs.h"
#include "npc.h"
#include "config.h"

#include <stdio.h>
#include <sys/timeb.h>
#include <time.h>


char ConfigPath[_MAX_PATH];  // dir where to find ini file
FUNCTIONENTRYPOINTS	*server;
char DebugBuffer[1024];
WORD state;
LinkedList *path = new LinkedList;
LinkedList *config = new LinkedList;
ITEMSTRUCT *item2;
CONFIGSTRUCT *cfg2;
ITEMSTRUCT *item3;
CONFIGSTRUCT *cfg3;
BOOL founditem = false;
BOOL boughtitem = false;
BYTE buyattempts = 0;
BYTE closeattempts = 0;
char itemerror[128] = "";
int itemcount = 0;
int totalitems = 0;
int addstep;
int addstep2;
__int8 randint;

NPCSTRUCT	npc;
WPSTRUCT	wp;
WPSTRUCT	wp2;
THISGAMESTRUCT *thisgame;
CONFIGSTRUCTGLOBAL globalConfig;
extern ITEMSTRUCT2 *itemsdb = new ITEMSTRUCT2;

char boughtitemname[128] = " ";
char boughtitemtime[128] = " ";
BOOL Recording = false;
BOOL SetNPC = false;
BOOL isRunning = false;
BOOL inGame = false; // d2hackit bug/feature work around
DWORD tick = 0;
DWORD itemID0;
DWORD itemID1;
DWORD itemID2;
DWORD itemID3;
DWORD itemID4;
DWORD itemID5;
DWORD itemID6;
DWORD itemID7;
DWORD itemID8;
DWORD itemID9;

LinkedItem_t *currentStep;


// module info
DWORD	ModuleVersion=MAKELONG(VERSION_MAJOR,VERSION_MINOR);
char	ModuleAuthor[]="Cigamit";
char	ModuleWebsite[]="www.advcs.org";
char	ModuleDescription[]="Shopbot for Diablo2 LOD";
char	ModuleEmail[]="jimmy@advcs.org";

// module commands
MODULECOMMANDSTRUCT ModuleCommands[]= {
	{
		"record",
		OnCommandRecord,
		"c4recordc0 toggles starting and stoping of path recording"
	},
	{
		"reload",
		OnCommandReload,
		"c4reloadc0 reloads ini file"
	},
	{
		"setnpc",
		OnCommandSetNPC,
		"setnpcc0 used to set which npc to trade with.\n"
		"c4setnpcc0 act<num> <npc name>\n"
		"c4setnpcc0 list act<num>"
	},
	{
		"townwp",
		OnCommandTownWP,
		"townwpc0 used to set the town waypoint.\n"
		"c4townwpc0 <waypoint name>\n"
	},
	{
		"otherwp",
		OnCommandOtherWP,
		"otherwpc0 used to set the other waypoint.\n"
		"c4otherwpc0 <waypoint name>\n"
	},
	{
		"savepath",
		OnCommandSavePath,
		"savepathc0 <pathname>"
		"Saves path to shopbot\\paths\\<pathname>.shp"
	},
	{
		"loadpath",
		OnCommandLoadPath,
		"loadpathc0 <pathname>\n"
		"Load shopbot\\paths\\<pathname>.shp"
	},
	{
		"loadconfig",
		OnCommandLoadConfig,
		"loadconfigc0 <pathname>\n"
		"Load shopbot\\<pathname>.ini"
	},
	{
		"help",
		OnCommandHelp,
		"c4setnpcc0 help!?"
	},
	{
		"start",
		OnCommandStart,
		"c4startc0 start the bot"
	},
	{
		"browse",
		OnCommandBrowse,
		"c4startc0 Work in Browse Mode"
	},
	{
		"stop",
		OnCommandStop,
		"c4stopc0 stop the bot"
	},
	{NULL}
};

// module command functions

BOOL PRIVATE OnCommandRecord(char **argv, int argc) {
	LinkedItem_t *step;
	if(Recording) {
		server->GamePrintString("c3:: c4ShopBotc3 :: c0Path Recording Stopped");
	} else {
		step = path->GetFirstItem();
		if(step != NULL) {
			server->GamePrintString("c3:: c4ShopBotc3 :: c0Clearing Previously recorded path");
			for(step = path->GetFirstItem();step != NULL;step = path->RemoveItem(step)){
				delete (LOCATIONSTRUCT*) step->lpData;
			}
		}
		server->GamePrintString("c3:: c4ShopBotc3 :: c0Path Recording Started");
	}
	// toggle it
	Recording = 1 - Recording;
	return true;
}

BOOL PRIVATE OnCommandTownWP(char **argv, int argc) {

	char waypoint[255];
	WPSTRUCT *wp;
	if(argc <= 2) {
		return false;
	}
	
	strcpy(waypoint,argv[2]);
	for(int i = 3; i < argc; i++) {
		sprintf(waypoint,"%s %s",waypoint,argv[i]);
	}

	wp = getWPbyName(waypoint);
	if(wp != NULL && wp->isTown) {
		memcpy(&globalConfig.townWP,wp,sizeof(WPSTRUCT));
		sprintf(DebugBuffer,"c3:: c4ShopBotc3 :: c0townwp set to: %s",waypoint);
		server->GamePrintString(DebugBuffer);
	} else {
		sprintf(DebugBuffer,"c1:: c4ShopBotc1 :: c0Invalid townwp: %s",waypoint);
		server->GamePrintString(DebugBuffer);
	}
	return true;
}

BOOL PRIVATE OnCommandOtherWP(char **argv, int argc) {

	char waypoint[255];
	WPSTRUCT *wp;
	if(argc <= 2) {
		return false;
	}
	
	strcpy(waypoint,argv[2]);
	for(int i = 3; i < argc; i++) {
		sprintf(waypoint,"%s %s",waypoint,argv[i]);
	}

	wp = getWPbyName(waypoint);
	if(wp != NULL) {
		memcpy(&globalConfig.otherWP,wp,sizeof(WPSTRUCT));
		sprintf(DebugBuffer,"otherWP set to: %s",waypoint);
		server->GamePrintString(DebugBuffer);
	} else {
		server->GamePrintString("c1:: c4ShopBotc1 :: c0Invalid townwp");
	}
	return true;
}
BOOL PRIVATE OnCommandSetNPC(char **argv, int argc) {
	if(argc != 4) {
		return false;
	}

	if(strcmpi("list",argv[2]) == 0) {
		// list possible npcs
		if(strcmpi("act1",argv[3]) == 0) {
			ListNPC(ACT1);
		} else if(strcmpi("act2",argv[3]) == 0) {
			ListNPC(ACT2);
		} else if(strcmpi("act3",argv[3]) == 0) {
			ListNPC(ACT3);
		} else if(strcmpi("act4",argv[3]) == 0) {
			ListNPC(ACT4);
		} else if(strcmpi("act5",argv[3]) == 0) {
			ListNPC(ACT5);
		} else {
			server->GamePrintString("Invalid act");
		}
		return true;
	} else if(strcmpi("act1",argv[2]) == 0) {
		SetNPCLid(ACT1,argv[3]);
	} else if(strcmpi("act2",argv[2]) == 0) {
		SetNPCLid(ACT2,argv[3]);
	} else if(strcmpi("act3",argv[2]) == 0) {
		SetNPCLid(ACT3,argv[3]);
	} else if(strcmpi("act4",argv[2]) == 0) {
		SetNPCLid(ACT4,argv[3]);
	} else if(strcmpi("act5",argv[2]) == 0) {
		SetNPCLid(ACT5,argv[3]);
	} else {
		server->GamePrintString("c1:: c4ShopBotc1 :: c0Invalid act");
	}
	return true;
}

BOOL PRIVATE OnCommandStart(char **argv, int argc) {
	state = STATE_OPENWPFROMTOWN;
	server->GamePrintString("c3:: c4ShopBotc3 :: c0Starting");
	isRunning = true;
	closeattempts = 0;
	return true;
}
BOOL PRIVATE OnCommandBrowse(char **argv, int argc) {
	state = STATE_BROWSE;
	server->GamePrintString("c3:: c4ShopBotc3 :: c0Now running in Browse Mode");
	isRunning = true;
	return true;
}
BOOL PRIVATE OnCommandStop(char **argv, int argc) {
	state = STATE_NONE;
	server->GamePrintString("c3:: c4ShopBotc3 :: c0Stopping");
	isRunning = false;
	if (globalConfig.textabovehead == true){
		server->GameCommandLine("overhead ");
	}
	return true;
}

BOOL PRIVATE OnCommandSavePath(char **argv, int argc) {
	if(argc != 3)
		return false;

	if(npc.lid == 0) {
		server->GamePrintString("c1:: c4ShopBotc1 :: c1You must set an npc first!");
		return false;
	}
	if(strlen(argv[2])+strlen(ConfigPath) > 1024) {
		server->GamePrintString("c1:: c4ShopBotc1 :: c0File name too long!");
		return false;
	}
	
	char filename[1024];
	sprintf(filename, "%s\\shopbot\\paths\\%s.sbp", ConfigPath, argv[2]);

	FILE *stream;
	if((stream = fopen(filename, "w")) == NULL)
	{
		sprintf(DebugBuffer, "c1:: c4ShopBotc1 :: c0Error creating %s", filename);
		server->GamePrintString(DebugBuffer);
		return true;
	}
	fprintf(stream, "#This is a shopbot path file do not modify!\n");
	fprintf(stream, "NPCID: %d\n", npc.lid);
	fprintf(stream, "TOWNWP: %s\n", globalConfig.townWP.name);
	fprintf(stream, "OTHERWP: %s\n", globalConfig.otherWP.name);
	
	currentStep = path->GetFirstItem();
	
	while(currentStep != NULL) {
		LOCATIONSTRUCT *locp;
		locp = (LOCATIONSTRUCT*)currentStep->lpData;
		currentStep = path->GetNextItem(currentStep);
		fprintf(stream, "STEP: %d,%d\n",locp->x, locp->y);
	}
	fclose(stream);
	
	sprintf(DebugBuffer,"c3:: c4ShopBotc3 :: c0Path Saved to shopbot\\%s.sbp",argv[2]);
	server->GamePrintString(DebugBuffer);

	return true;
}
BOOL PRIVATE OnCommandReload(char **argv, int argc) {
	LinkedItem_t *cfg;
	// delete the old config
	for(cfg = config->GetFirstItem();cfg != NULL;cfg = config->RemoveItem(cfg)){
		delete (CONFIGSTRUCT*) cfg->lpData;
	}
	// load new config
	if(!LoadConfig(globalConfig.configf)) {
		sprintf(DebugBuffer,"c1:: c4ShopBotc1 :: c0Error loading Config - %s.ini",globalConfig.configf);
		server->GamePrintString(DebugBuffer);	
	} else {
		sprintf(DebugBuffer,"c3:: c4ShopBotc3 :: c0%s.ini reloaded",globalConfig.configf);
		server->GamePrintString(DebugBuffer);
	}
	return true;
}
BOOL PRIVATE OnCommandLoadConfig(char **argv, int argc) {
	if(argc != 3)
		argv[2] = "shopbot";
	LinkedItem_t *cfg;
	// delete the old config
	for(cfg = config->GetFirstItem();cfg != NULL;cfg = config->RemoveItem(cfg)){
		delete (CONFIGSTRUCT*) cfg->lpData;
	}
	// load new config
	if(!LoadConfig(argv[2])) {
		globalConfig.configf = "shopbot";
		server->GamePrintString("c1:: c4ShopBotc1 :: c0Error loading Config");
		sprintf(DebugBuffer, "c3:: c4ShopBotc3 :: c0Reloading default config - %s", globalConfig.configf);
		server->GamePrintString(DebugBuffer);
		LoadConfig(globalConfig.configf);
	} else {
		sprintf(DebugBuffer, "c3:: c4ShopBotc3 :: c0Loaded %s.ini", argv[2]);
		server->GamePrintString(DebugBuffer);
        globalConfig.configf = argv[2];
	}
return true;
}

BOOL PRIVATE OnCommandLoadPath(char **argv, int argc) {

	if(argc != 3)
		return false;

	WORD lid;
	WORD x,y;

	char filename[1024], line[255];
	FILE *stream;
	LinkedItem_t *step;	

	//Delete path if present.
	for(step = path->GetFirstItem();step != NULL;step = path->RemoveItem(step)){
		delete (LOCATIONSTRUCT*) step->lpData;
	}

	sprintf(filename, "%s\\shopbot\\paths\\%s.sbp", ConfigPath, argv[2]);
	
	if((stream = fopen(filename, "r")) == NULL) {
		sprintf(DebugBuffer, "c1:: c4ShopBotc1 :: c0Unable to read from %s", filename);
		server->GamePrintString(DebugBuffer);
		return true;
	}

	// skip initial line
	while(fgetc(stream) != '\n') {};

	fscanf(stream, "NPCID: %u\n", &lid);

	for(int i = 0;i < NPC_TOTAL;i++)
	{
		if(allNPC[i].lid == lid)
		{
			npc = allNPC[i];
			SetNPC = true;
		}
	}

	if(!SetNPC) {
		server->GamePrintString("c1:: c4ShopBotc1 :: c0Unable to determine NPC from NPCID!");
		fclose(stream);
		return true;
	}

	
	WPSTRUCT *wp;
	// this is messed up.  I can't fscanf(stream,"TOWNWP: %[a-zA-Z0-9 ]s\n", line);
	fscanf(stream, "%s\n", line);
	fscanf(stream, "%[a-zA-Z0-9 ]s\n", line);

	wp = getWPbyName(line);
	if(wp != NULL || !wp->isTown) {
		memcpy(&globalConfig.townWP,wp,sizeof(WPSTRUCT));
	} else {
		server->GamePrintString("c1:: c4ShopBotc1 :: c0Invalid town wp from path file.");
		fclose(stream);
		return true;
	}	
	
	// same deal.  can't fscanf(stream,"OTHERWP: %[a-zA-Z0-9 ]s\n", line);
	fscanf(stream, "%s\n", line);
	fscanf(stream, "%[a-zA-Z0-9 ]s\n", line);

	wp = getWPbyName(line);
	if(wp != NULL) {
		memcpy(&globalConfig.otherWP,wp,sizeof(WPSTRUCT));
	} else {
		server->GamePrintString("c1:: c4ShopBotc1 :: c0Invalid other wp from path file.");
		fclose(stream);
		return true;
	}
		
	while(fscanf(stream,"%s",line) != EOF) {
		fscanf(stream,"%u,%u",&x, &y);
		LOCATIONSTRUCT *lstep = new LOCATIONSTRUCT;
		lstep->x = x;
		lstep->y = y;
		path->AddItem(lstep);
	}
	
	fclose(stream);

    sprintf(DebugBuffer, "c3:: c4ShopBotc3 :: c0Path Loaded and NPC set to %s", npc.name);
	server->GamePrintString(DebugBuffer);
    if (globalConfig.otherWP.isaWP){
		sprintf(DebugBuffer, "c3:: c4ShopBotc3 :: c0Go through the %s waypoint, then come back to %s",globalConfig.otherWP.name,globalConfig.townWP.name);
	}else{
		sprintf(DebugBuffer, "c3:: c4ShopBotc3 :: c0Go through the %s portal, then come back to %s",globalConfig.otherWP.name,globalConfig.townWP.name);
	}
	server->GamePrintString(DebugBuffer);

	sprintf(DebugBuffer, "c3:: c4ShopBotc3 :: c0and run '.shopbot start'");
	server->GamePrintString(DebugBuffer);
	return true;
}

VOID EXPORT OnGameJoin(THISGAMESTRUCT* game) {
	LinkedItem_t *step;
	thisgame = game;
	// delete paths that may already exist
	for(step = path->GetFirstItem();step != NULL;step = path->RemoveItem(step)){
		delete (LOCATIONSTRUCT*) step->lpData;
	}
	inGame = true; // d2hackit bug/feature work around
	if (state != STATE_BROWSE) {
		state = STATE_NONE;
		isRunning = false;
	}else{
		isRunning = true;
	}
}

VOID EXPORT OnGameLeave(THISGAMESTRUCT* game) {
	inGame = false; // d2hackit bug/feature work around

	if (state != STATE_BROWSE) {
		state = STATE_NONE;
		isRunning = false;
	}else{
		isRunning = true;
	}
}

// functions called by d2hackit
BOOL EXPORT OnClientStart() {

	server->GamePrintString("Shopbot Developers: Cigamit - (jimmy@advcs.org)");
	server->GamePrintString("                                   Ackmed - (ackmed@gotwalls.com)");
	server->GamePrintString("                                   Termter - Korean (termter@hanmail.net)");

	globalConfig.configf = "shopbot";
	return LoadConfig("shopbot");
}
// outgoing packet
DWORD EXPORT OnGamePacketBeforeSent(BYTE* aPacket, DWORD aLen) {
	if(isRunning && aPacket[0] == 0x03) {
		//Client walk update, I think this is Icky's findings, not sure, but if it's
        //he should have the thanks for it:)
		// this needs to move into pachethelper.cpp
		BYTE upd[16];
        upd[0] = 0x0f;
        upd[6] = 0x17;
		memcpy (upd + 2, &thisgame->player->PlayerID, 4);
		memcpy (upd + 7, aPacket + 1, 4);
		memcpy (upd + 12, &thisgame->player->PlayerPositionX, 2);
		memcpy (upd + 14, &thisgame->player->PlayerPositionY, 2);
        server->GameSendPacketToGame (upd, 16);
        return aLen;
    }

	// if recording save any movement 
	if(Recording) {
		if(aPacket[0] == 0x03) {
			LOCATIONSTRUCT *step = new LOCATIONSTRUCT;
			LOCATIONSTRUCT *prevStep;
			memcpy(&step->x,&aPacket[1],2);
			memcpy(&step->y,&aPacket[3],2);
			if(path->GetLastItem() != NULL) {
				prevStep = (LOCATIONSTRUCT*)path->GetLastItem()->lpData;
				// only record if its a new step
				if(step != prevStep) {
					path->AddItem(step);
				} else {
					delete step;
				}
			} else {
				path->AddItem(step);
			}
		}
	}

	 //deny client sync with server while bot is running
	if(isRunning && aPacket[0] == 0x5f) {
		return 0;
	}
	return aLen;

}

// incoming packet
DWORD EXPORT OnGamePacketBeforeReceived(BYTE* aPacket, DWORD aLen) {
/*	if(state != STATE_NONE && (aPacket[0] == 0x63) ) {
		// work around to send empty packet taken from
		// spoof module by Sonata.  THX!
		memset(aPacket, 0, aLen);	// Zero out the packet
		aPacket[0] = 0x77;			// Turn it into a dummy
		aPacket[1] = 0x06;
		return aLen;
	}

	*/
	if(SetNPC && aPacket[0] == 0x55) {
		WORD check;
		memcpy( &check, &aPacket[5], 2);
        if(npc.lid == check) {
			memcpy(&npc.npcID, &aPacket[1], 4);
            SetNPC = false;
		}
	}

	// This packet tells us the error if not bought, and possibly other things
	if (aPacket[0] == 0x2A && (state == STATE_BUYITEMS || state == STATE_BUYITEMSWAIT)){
		if (aPacket[1] == 0x00 && (aPacket[2] == 0x07)){
				memcpy(&itemerror, " (Item not found)",17);
		}
		if (aPacket[1] == 0x00 && (aPacket[2] == 0x0A)){
				memcpy(&itemerror, " (Not enough space)",19);
		}
		if (aPacket[1] == 0x00 && aPacket[2] == 0x0C){
				memcpy(&itemerror, " (Not enough gold)",18);
		}
	}
	if(aPacket[0] == ITEM_MESSAGEID_DROP && isRunning && (state == STATE_BUYITEMS || state == STATE_BUYITEMSWAIT)) {
		if(aPacket[1] == 0x0C && isRunning && state != STATE_BROWSE){
			ITEMSTRUCT *item;
			item = ParseItemDrop(aPacket,aLen);
			DWORD itemID;
			if (itemcount == 1)
				itemID = itemID1;
			if (itemcount == 2)
				itemID = itemID2;
			if (itemcount == 3)
				itemID = itemID3;
			if (itemcount == 4)
				itemID = itemID4;
			if (itemcount == 5)
				itemID = itemID5;
			if (itemcount == 6)
				itemID = itemID6;
			if (itemcount == 7)
				itemID = itemID7;
			if (itemcount == 8)
				itemID = itemID8;
			if (itemcount == 9)
				itemID = itemID9;
			if (item != NULL){
				if (item->ItemID == itemID) {
					boughtitem = true;
				}
			}
			}
	
	} else if(aPacket[0] == ITEM_MESSAGEID_DROP && aPacket[1] == 0x0B && isRunning && (state == STATE_BROWSE || state == STATE_MAKESUREOPENSTORE || state == STATE_OPENSTORE || state == STATE_RECIEVEITEMS || state == STATE_CLOSESTORE)) {
		ITEMSTRUCT *item;
		item = ParseItemDrop(aPacket,aLen);


		if (state != STATE_NONE && state != STATE_ANTIIDLE && state != STATE_BROWSE) {
			state = STATE_RECIEVEITEMS;
			tick = 0;
		}
		if(isRunning && item != NULL && state != STATE_BROWSE) {
			if (globalConfig.showallitems==true){
				DumpItemStruct(item);
			}
		}
		
		// check for match needs to go here
		if(item != NULL) {
			CONFIGSTRUCT *cfg; 
			cfg = ItemMatchCheck(item);

			if(cfg != NULL) {
				// we have a match
				totalitems++;
				if (totalitems == 1) {
					itemsdb->cfg1 = cfg;
					itemID1 = item->ItemID;
				}
				if (totalitems == 2) {
					itemsdb->cfg2 = cfg;
					itemID2 = item->ItemID;
				}
				if (totalitems == 3) {
					itemsdb->cfg3 = cfg;
					itemID3 = item->ItemID;
				}
				if (totalitems == 4) {
					itemsdb->cfg4 = cfg;
					itemID4 = item->ItemID;
				}
				if (totalitems == 5) {
					itemsdb->cfg5 = cfg;
					itemID5 = item->ItemID;
				}
				if (totalitems == 6) {
					itemsdb->cfg6 = cfg;
					itemID6 = item->ItemID;
				}
				if (totalitems == 7) {
					itemsdb->cfg7 = cfg;
					itemID7 = item->ItemID;
				}
				if (totalitems == 8) {
					itemsdb->cfg8 = cfg;
					itemID8 = item->ItemID;
				}
				if (totalitems == 9) {
					itemsdb->cfg9 = cfg;
					itemID9 = item->ItemID;
				}
				// print stuff if description is defined.
				
				if(globalConfig.autoBuy == false && state != STATE_BROWSE) {
					if (cfg->Description[0] != '\0'){
						sprintf(DebugBuffer,"c3:: c4ShopBotc3 :: c0Item Found - %s",cfg->Description);
					} else {
						if (item->PrefixName != '\0')
							sprintf(DebugBuffer,"c3:: c4ShopBotc3 :: c0Item Found - c1%s %s %s",item->PrefixName,item->BaseName,item->SuffixName);
						else
							sprintf(DebugBuffer,"c3:: c4ShopBotc3 :: c0Item Found - c1%s %s",item->BaseName,item->SuffixName);
					}
					server->GamePrintString(DebugBuffer);
				}
				if (state == STATE_BROWSE){
					if (cfg->Description[0] != '\0'){
						sprintf(DebugBuffer,"c3:: c4ShopBotc3 :: c0Item Found - %s",cfg->Description);
					} else {
						if (item->PrefixName != '\0')
							sprintf(DebugBuffer,"c3:: c4ShopBotc3 :: c0Item Found - c1%s %s %s",item->PrefixName,item->BaseName,item->SuffixName);
						else
							sprintf(DebugBuffer,"c3:: c4ShopBotc3 :: c0Item Found - c1%s %s",item->BaseName,item->SuffixName);
					}
					server->GamePrintString(DebugBuffer);

				}
			} 
			delete item;
		}

	} else if(aPacket[0] == 0x6d) {  // npc update
		if(npc.npcID != 0) {
			WORD npcID;
			memcpy(&npcID,&aPacket[1],4);
			// see if this is our npc
			if(npc.npcID == npcID) {
				memcpy(&npc.pos.x,&aPacket[5],2);
				memcpy(&npc.pos.y,&aPacket[7],2);
			}
		}
	} else if(aPacket[0] == 0x51) {	// possible waypoint info
		if(aPacket[1] == 0x02) { 
			WORD lid;
			memcpy(&lid,&aPacket[6],2);
		
			if(isWP(lid)) {
				if (aPacket[13] == 0x00){
					if (globalConfig.otherWP.lid == lid || globalConfig.townWP.lid == lid){	
						memcpy(&wp.pos.x,&aPacket[8],2);
						memcpy(&wp.pos.y,&aPacket[10],2);
						memcpy(&wp.entityID,&aPacket[2],4);
					}
						//wp.lid = lid;
				}else{
						if (aPacket[13] == 0x79 && globalConfig.otherWP.isaWP == false){
							memcpy(&globalConfig.otherWP.pos.x,&aPacket[8],2);
							memcpy(&globalConfig.otherWP.pos.y,&aPacket[10],2);
							memcpy(&globalConfig.otherWP.entityID,&aPacket[2],4);
							memcpy(&wp.pos.x,&aPacket[8],2);
							memcpy(&wp.pos.y,&aPacket[10],2);
							memcpy(&wp.entityID,&aPacket[2],4);
							wp.lid = lid;
						}
						if (aPacket[13] == 0x6d && globalConfig.townWP.isaWP == false){
							memcpy(&globalConfig.townWP.pos.x,&aPacket[8],2);
							memcpy(&globalConfig.townWP.pos.y,&aPacket[10],2);
							memcpy(&globalConfig.townWP.entityID,&aPacket[2],4);
							memcpy(&wp.pos.x,&aPacket[8],2);
							memcpy(&wp.pos.y,&aPacket[10],2);
							memcpy(&wp.entityID,&aPacket[2],4);
							wp.lid = lid;
						}
				}
				// should fill in position at some point.
				wp.isStale = false;
			}
		}
	}

		return aLen;
}

// is run ~every 1/10th a second
DWORD EXPORT OnGameTimerTick(void) {
	
	// d2hackit bug/feature work around
	// OnGameTimerTick() is called even while outside of a game
	// this can lead to diablo crashing.
	if(!inGame) {
		return true;
	}

	tick++;
	if(state == STATE_NONE || state == STATE_BROWSE) {
		tick = 0;
	} else if(tick > 100) { // if we have been in a state for more then 10 seconds something is wrong
	
		if (globalConfig.displaytext == true){
			if (globalConfig.textabovehead == true){
				server->GameCommandLine("overhead I am lost! Going back to WP.");
			} else {
				server->GamePrintString("c1:: c4ShopBotc1 :: c1 Lost.  Attempting to retake path to WP");
				server->GamePrintString("c1:: c4ShopBotc1 :: c0 Your path may be wrong, or you might have been stuck, try again.");
			}
		}

		if (globalConfig.townWP.isaWP){
			TakeWayPoint(wp.entityID,globalConfig.townWP.wpNum);
		}else{
			TakePortal(globalConfig.townWP.wpNum);
		}

		state = STATE_WALKWP_START;
		wp.isStale = false;
		tick = 0;
	
	} else {
		switch(state) {
			case STATE_BROWSE:
				break;
			case STATE_ANTIIDLE:

				if(tick == 20) {
					randint = rand();
					addstep = 0;
					addstep2 = 0;
						if (randint < -25)
							addstep = -1;
						if (randint < -75)
							addstep = -2;
						if (randint < -120)
							addstep = -3;
						if (randint > 25)
							addstep = 1;
						if (randint > 75)
							addstep = 2;
						if (randint > 120)
							addstep = 3;
						randint = rand();
						if (randint < -25)
							addstep2 = -1;
						if (randint < -75)
							addstep2 = -2;
						if (randint < -120)
							addstep2 = -3;
						if (randint > 25)
							addstep2 = 1;
						if (randint > 75)
							addstep2 = 2;
						if (randint > 120)
							addstep2 = 3;

					TakeStep(thisgame->player->PlayerPositionX+addstep,thisgame->player->PlayerPositionY + addstep2);
				} else if(tick == 40) {
					TakeStep(thisgame->player->PlayerPositionX-addstep,thisgame->player->PlayerPositionY - addstep2);
				} else if(tick >= 60) {
					SendSoundToServer(26);  // this is for you;)
					tick = 0;
				}
				break;
			case STATE_WALKCLOSERTOWP:
				closeattempts++;
				if (closeattempts > 5){
					tick = 110;
					closeattempts = 0;
					break;
				}
				TakeStep(wp.pos.x,wp.pos.y);
				if (globalConfig.displaytext == true){
					if (globalConfig.textabovehead == true){
						if (globalConfig.otherWP.isaWP) {
							server->GameCommandLine("overhead Walking Closer to WP");
						} else {
							server->GameCommandLine("overhead Walking Closer to Portal");
						}
					} else {
						if (globalConfig.otherWP.isaWP) {
							server->GamePrintString("c3:: c4ShopBotc3 :: c0Walking Closer to WP");
						} else {
							server->GamePrintString("c3:: c4ShopBotc3 :: c0Walking Closer to Portal");
						}
					}
				}
				state = STATE_OPENWPFROMTOWN;
				tick = 0;
				break;
			case STATE_OPENWPFROMTOWN:

				if (globalConfig.displaytext == true && tick < 2){
					if (globalConfig.textabovehead == true){
						if (globalConfig.otherWP.isaWP) {
							sprintf(DebugBuffer, "overhead Taking WP to %s",globalConfig.otherWP.name);
						} else {
							sprintf(DebugBuffer, "overhead Taking Portal to %s",globalConfig.otherWP.name);
						}
						server->GameCommandLine(DebugBuffer);
					} else {
						if (globalConfig.otherWP.isaWP) {
							server->GamePrintString("c3:: c4ShopBotc3 :: c0Taking WP out of town");
						} else {
							server->GamePrintString("c3:: c4ShopBotc3 :: c0Taking Portal out of town");
						}
					}
				}
				if (tick > 4) {
					wp.isStale = true;
					if (globalConfig.otherWP.isaWP){
						TakeWayPoint(wp.entityID,globalConfig.otherWP.wpNum);
					}else{
						TakePortal(globalConfig.otherWP.wpNum);
					}
					state = STATE_WPFROMTOWN;
					tick = 0;
				// Seed the Randomize with the time, so its different everytime
				srand( (unsigned)time( NULL ) );
				}
				break;
			case STATE_WPFROMTOWN:	// leave town.
				if (tick > 13) {
					state = STATE_WALKCLOSERTOWP;
				}
				if(!wp.isStale) {
					// next state is taking wp back to town.
					state = STATE_OPENWPTOTOWN;
					tick = 0; // reset tick
					wp.isStale = true;
				}
				break;
			case STATE_OPENWPTOTOWN:
				if (globalConfig.displaytext == true && tick < 2){
					if (globalConfig.textabovehead == true){
						if (globalConfig.townWP.isaWP) {
						sprintf(DebugBuffer, "overhead Taking the WP to %s",globalConfig.townWP.name);
						} else {
						sprintf(DebugBuffer, "overhead Taking the Portal to %s",globalConfig.townWP.name);
						}
						server->GameCommandLine(DebugBuffer);
					} else {
						if (globalConfig.townWP.isaWP) {
						server->GamePrintString("c3:: c4ShopBotc3 :: c0Taking WP to town");
						} else {
						server->GamePrintString("c3:: c4ShopBotc3 :: c0Taking Portal to town");
						}
					}
				}
				if (tick > 6) {
					if (globalConfig.otherWP.isaWP){
						TakeWayPoint(wp.entityID,globalConfig.townWP.wpNum);
					}else{
						TakePortal(globalConfig.townWP.wpNum);
					}			
					state = STATE_WPTOTOWN;
					tick = 0;
					wp.isStale = true;
				}
				break;
			case STATE_WPTOTOWN:
				if(!wp.isStale) {
					// next state is to start walking to npc
					state = STATE_WALKNPC_START;
					tick = 0;
				}
				break;
			case STATE_WALKNPC_START:
					if (globalConfig.displaytext == true){
						if (globalConfig.textabovehead == true){
							sprintf(DebugBuffer, "overhead Walking to %s",npc.name);
							server->GameCommandLine(DebugBuffer);
						} else {
							server->GamePrintString("c3:: c4ShopBotc3 :: c0Walking to NPC");
						}
					}
					
					currentStep = path->GetFirstItem();
					// start walking
					state = STATE_WALKNPC;
					tick = 0;
				break;
			case STATE_WALKNPC:
				if(currentStep != NULL) {
					if(tick > globalConfig.steptime) { // dont try walking too fast, should make this adjustable
						LOCATIONSTRUCT *loc;
						loc = (LOCATIONSTRUCT*)currentStep->lpData;
						randint = rand();
						addstep = 0;
							if (randint < -25)
								addstep = -1;
							if (randint < -75)
								addstep = -2;
							if (randint < -120)
								addstep = -3;
							if (randint > 25)
								addstep = 1;
							if (randint > 75)
								addstep = 2;
							if (randint > 120)
								addstep = 3;
							randint = rand();
							if (randint < -25)
								addstep2 = -1;
							if (randint < -75)
								addstep2 = -2;
							if (randint < -120)
								addstep2 = -3;
							if (randint > 25)
								addstep2 = 1;
							if (randint > 75)
								addstep2 = 2;
							if (randint > 120)
								addstep2 = 3;

						TakeStep(loc->x + addstep,loc->y + addstep2);
						currentStep = path->GetNextItem(currentStep);
					
						// last point in our recorded path, try walking to where the NPC is located
						if(currentStep == NULL) {
							if(npc.npcID == 0) {
								// dont have an npc!?
								server->GamePrintString("c1:: c4ShopBotc1 :: c1Dont have an NPC!, shopbot disabled");
								server->GamePrintString("c1:: c4ShopBotc1 :: c0Try walking to the NPC and talking to him, then start shopbot again");
								if (globalConfig.textabovehead == true){
									server->GameCommandLine("overhead Dont have an NPC, c1disabling");
								}
								state = STATE_NONE;
								isRunning = false;
								break;
							}
							TakeStep(npc.pos.x,npc.pos.y);
							state = STATE_OPENSTORE;
							itemID1 = NULL;
							itemID2 = NULL;
							itemID3 = NULL;
							itemID4 = NULL;
							itemID5 = NULL;
							itemID6 = NULL;
							itemID7 = NULL;
							itemID8 = NULL;
							itemID9 = NULL;
							itemID0 = NULL;
							itemcount = 0;
							totalitems = 0;
							boughtitem = false;
							closeattempts = 0;
						}
						// reset tick
						tick = 0;
					}		
				}
				break;
			case STATE_WALKCLOSERTONPC:
				closeattempts++;
				if (closeattempts > 5){
					tick = 110;
					closeattempts = 0;
					break;
				}


				TakeStep(npc.pos.x,npc.pos.y);
				state = STATE_OPENSTORE;
				tick = 0;
				if (globalConfig.displaytext == true){
					if (globalConfig.textabovehead == true){
						server->GameCommandLine("overhead Walking Closer to NPC");
					} else {
						server->GamePrintString("c3:: c4ShopBotc3 :: c0Walking Closer to NPC");
					}
				}
				break;
			case STATE_OPENSTORE:
					if(tick > 7) {
						OpenStore(npc.npcID,npc.pos.x,npc.pos.y);
						state = STATE_MAKESUREOPENSTORE;
						tick = 0;
					}
				break;
			case STATE_MAKESUREOPENSTORE:
				if(tick > 10) {
					state = STATE_WALKCLOSERTONPC;
				}
				break;
			case STATE_RECIEVEITEMS:
				if (globalConfig.displaytext == true && tick < 2){
					if (globalConfig.textabovehead == true){
						sprintf(DebugBuffer, "overhead Opening Store with %s",npc.name);
						server->GameCommandLine(DebugBuffer);
					} else {
						server->GamePrintString("c3:: c4ShopBotc3 :: c0Opening Store with NPC");
					}
				}
				if (tick > 8) {
					state = STATE_BUYITEMS;
				}
				break;
			case STATE_BUYITEMS:
				if (globalConfig.autoBuy == false || (totalitems == itemcount && buyattempts == 0)) {
					state = STATE_CLOSESTORE;
					break;
				}
				if (buyattempts == 0){
					itemcount++;
					boughtitem = false;
					if (itemcount == 1){
						cfg3 = itemsdb->cfg1;
						itemID0 = itemID1;
					}
					if (itemcount == 2){
						cfg3 = itemsdb->cfg2;
						itemID0 = itemID2;
					}
					if (itemcount == 3){
						cfg3 = itemsdb->cfg3;
						itemID0 = itemID3;
					}
					if (itemcount == 4){
						cfg3 = itemsdb->cfg4;
						itemID0 = itemID4;
					}
					if (itemcount == 5){
						cfg3 = itemsdb->cfg5;
						itemID0 = itemID5;
					}
					if (itemcount == 6){
						cfg3 = itemsdb->cfg6;
						itemID0 = itemID6;
					}
					if (itemcount == 7){
						cfg3 = itemsdb->cfg7;
						itemID0 = itemID7;
					}
					if (itemcount == 8){
						cfg3 = itemsdb->cfg8;
						itemID0 = itemID8;
					}
					if (itemcount == 9){
						cfg3 = itemsdb->cfg9;
						itemID0 = itemID9;
					}
				}
				
				if (boughtitem){
					sprintf(DebugBuffer,"c3:: c4ShopBotc3 :: c0Item Purchased Successfully");
					server->GamePrintString(DebugBuffer);
					buyattempts = 0;
					tick = 0;
					if (globalConfig.boughtfile == true){
						struct _timeb timebuffer;
						char *timeline;
						_ftime( &timebuffer );
						timeline = ctime( & ( timebuffer.time ) );
						sprintf(boughtitemtime,"%.19s", timeline);
						FILE *stream;
						char filename[1024];
						sprintf(filename, "%s\\shopbot\\items-bought.txt", ConfigPath);
						stream = fopen(filename, "a");
						fprintf(stream, "%s - %s",boughtitemtime,boughtitemname);
						fclose(stream);
					}
					break;
				}
				if (buyattempts == 0){
					memcpy(&itemerror, "",0);
					if(cfg3->Description[0] != '\0')
						sprintf(DebugBuffer,"c3:: c4ShopBotc3 :: c0Item Found - %s",cfg3->Description);
					else
						sprintf(DebugBuffer,"c3:: c4ShopBotc3 :: c0Item Found - c1No Description");
					server->GamePrintString(DebugBuffer);
				}
				if (buyattempts < 3){
					buyattempts++;
					BuyItem(itemID0, npc.npcID);
					state = STATE_BUYITEMSWAIT;
					tick = 0;
					break;
				}

				tick=0;
				buyattempts = 0;
				sprintf(DebugBuffer, "c1:: c4ShopBotc1 :: c1Item Buying Unsuccessful!!%s",itemerror);
				server->GamePrintString(DebugBuffer);
					if (cfg3 != NULL){
						if (cfg3->Stop == 1){
							server->GamePrintString("c1:: c4ShopBotc1 :: c1Item Purchase Failed - Going into Anti-Idle Mode");
							state = STATE_ANTIIDLE;
							isRunning = 0;
							break;
						}
					}

				break;
			case STATE_BUYITEMSWAIT:
				if(tick > 2) {
					tick = 0;
					state = STATE_BUYITEMS;
				}
				break;
			case STATE_CLOSESTORE:
				if(tick > 9) { // wait ~9/10th second before closing store to allow packets to get here
					if (globalConfig.displaytext == true){
						if (globalConfig.textabovehead == true){
							sprintf(DebugBuffer, "overhead Closing Store with %s",npc.name);
							server->GameCommandLine(DebugBuffer);
						} else {
							server->GamePrintString("c3:: c4ShopBotc3 :: c0Closing Store with NPC");
						}
					}
					
					CloseStore(npc.npcID);
					state = STATE_WALKWP_START;
					tick = 0;
				}
				break;

			case STATE_WALKWP_START:  // basicly the same as walking to npc, but we traverse the linkedlist backwords
				if(wp.entityID != 0) {
					if (globalConfig.displaytext == true){
						if (globalConfig.textabovehead == true){
							if (globalConfig.otherWP.isaWP) {
								server->GameCommandLine("overhead Walking to WP");
							} else {
								server->GameCommandLine("overhead Walking to Portal");
							}
						} else {
							if (globalConfig.otherWP.isaWP) {
								server->GamePrintString("c3:: c4ShopBotc3 :: c0Walking to WP");
							} else {
								server->GamePrintString("c3:: c4ShopBotc3 :: c0Walking to Portal");
							}
						}
					}
					currentStep = path->GetLastItem();					
					// start walking
					state = STATE_WALKWP;
					tick = 0;
				} else {
					// dont have an wp!?
					server->GamePrintString("c1:: c4ShopBotc1 :: c1Dont have an WP!, c1shopping c1disabled");
					if (globalConfig.otherWP.isaWP) {
						server->GamePrintString("c1:: c4ShopBotc1 :: c0Try walking to the WP, go through it, and come back to town, then start shopbot again.");
					} else {
						server->GamePrintString("c1:: c4ShopBotc1 :: c0Try walking to the Portal, go through it, and come back to town, then start shopbot again.");
					}
					state = STATE_NONE;
				}
				break;

			case STATE_WALKWP:
				if(currentStep != NULL) {
					if(tick > globalConfig.steptime) { // dont try walking too fast, should make this adjustable
						LOCATIONSTRUCT *loc;
						loc = (LOCATIONSTRUCT*)currentStep->lpData;
//							ForceClientViewLocation(loc->x,loc->y,0);
						randint = rand();
						addstep = 0;
							if (randint < -25)
								addstep = -1;
							if (randint < -75)
								addstep = -2;
							if (randint < -120)
								addstep = -3;
							if (randint > 25)
								addstep = 1;
							if (randint > 75)
								addstep = 2;
							if (randint > 120)
								addstep = 3;
							randint = rand();
							if (randint < -25)
								addstep2 = -1;
							if (randint < -75)
								addstep2 = -2;
							if (randint < -120)
								addstep2 = -3;
							if (randint > 25)
								addstep2 = 1;
							if (randint > 75)
								addstep2 = 2;
							if (randint > 120)
								addstep2 = 3;
						TakeStep(loc->x + addstep,loc->y + addstep2);
						currentStep = path->GetPrevItem(currentStep);
						
						// first point in our recorded path 
						if(currentStep == NULL) {
							TakeStep(wp.pos.x,wp.pos.y);
							state = STATE_OPENWPFROMTOWN;
						}
						// reset tick
						tick = 0;
					}		
				}
				wp.isStale = true;
				break;
			default:
			break;
		}
	}
	return true;
}

BOOL LoadConfig(char* configname) {
	char ConfigFile[1024];
	char *Sections;
	char error[1024];
	char *rval;
	int length,counter;
	CONFIGSTRUCT *cfg;

	sprintf(ConfigFile,"%s\\shopbot\\%s.ini",ConfigPath,configname);


	if (_access(ConfigFile, 0)) { 
		char error[1024];
		sprintf(error, "c4ShopBotc1 :: c0Unable to open Config: %s", ConfigFile);
		server->GamePrintError(error);
		return false;
	}
	// Try getting the data in 64-byte increments
	DWORD  alloc=0;
	DWORD  allocStep = 20;

	while (TRUE) {
		alloc+=allocStep;
		Sections = new char[alloc];
		length = GetPrivateProfileSectionNames(Sections,alloc,ConfigFile);
		
		if(length + 1 != alloc - 1 ) {
			break;
		}
		delete Sections;
	}

	counter = 0;

NEXT:
	while(counter < length) {
		cfg = new CONFIGSTRUCT;
		cfg->Description[0] = '\0';
		cfg->BaseName[0] = '\0';
		cfg->MagicPrefix[0] = '\0';
		cfg->MagicSuffix[0] = '\0';
		cfg->Category[0] = '\0';
		cfg->Quality[0] = '\0';
		char* configname2;
		configname2 = "";
		sprintf(configname2,"shopbot\\%s",configname);
		cfg->item.ItemCode[0] = '\0';

		if(strlen(&Sections[counter]) > 128 || Sections[counter] == '\0') {
			
			counter = counter + strlen(&Sections[counter]) + 1;
			delete cfg;
			goto NEXT;
		}
		

		if(strcmpi("global",&Sections[counter]) == 0) {
			
			counter = counter + strlen(&Sections[counter]) + 1;
			delete cfg;

			rval = server->GetHackProfileString(configname2,"global","displaytext");
			if(strlen(rval)) {
				if(atoi(rval)) {
					globalConfig.displaytext = true;
				} else {
					globalConfig.displaytext = false;
				}
			} else {
				globalConfig.displaytext = true;
			}

			rval = server->GetHackProfileString(configname2,"global","textabovehead");
			if(strlen(rval)) {
				if(atoi(rval)) {
					globalConfig.textabovehead = true;
				} else {
					globalConfig.textabovehead = false;
				}
			} else {
				globalConfig.textabovehead = false;
			}

			rval = server->GetHackProfileString(configname2,"global","showallitems");
			if(strlen(rval)) {
				if(atoi(rval)) {
					globalConfig.showallitems = true;
				} else {
					globalConfig.showallitems = false;
				}
			} else {
				globalConfig.showallitems = false;
			}

			rval = server->GetHackProfileString(configname2,"global","autobuy");
			if(strlen(rval)) {
				if(atoi(rval)) {
					globalConfig.autoBuy = true;
				} else {
					globalConfig.autoBuy = false;
				}
			} else {
				globalConfig.autoBuy = false;
			}

			rval = server->GetHackProfileString(configname2,"global","itemsfile");
			if(strlen(rval)) {
				if(atoi(rval)) {
					globalConfig.itemsfile = true;
				} else {
					globalConfig.itemsfile = false;
				}
			} else {
				globalConfig.itemsfile = false;
			}

			rval = server->GetHackProfileString(configname2,"global","boughtfile");
			if(strlen(rval)) {
				if(atoi(rval)) {
					globalConfig.boughtfile = true;
				} else {
					globalConfig.boughtfile = false;
				}
			} else {
				globalConfig.boughtfile = false;
			}

			rval = server->GetHackProfileString(configname2,"global","usebind");
			if(strlen(rval)) {
				if(atoi(rval)) {
					globalConfig.usebind = true;
				} else {
					globalConfig.usebind = false;
				}
			} else {
				globalConfig.usebind = true;
			}
			if (globalConfig.usebind == true){
				rval = server->GetHackProfileString(configname2,"global","bindstart");
				if(strlen(rval)) {
					globalConfig.bindstart = rval;
					sprintf(DebugBuffer, "bind set %s 00 say .shopbot start",globalConfig.bindstart);
					server->GameCommandLine(DebugBuffer);
				}else{
					globalConfig.bindstart = '\0';
				}

				rval = server->GetHackProfileString(configname2,"global","bindstop");
				if(strlen(rval)) {
					globalConfig.bindstop = rval;
					sprintf(DebugBuffer, "bind set %s 00 say .shopbot stop",globalConfig.bindstop);
					server->GameCommandLine(DebugBuffer);
				}else{
					globalConfig.bindstart = '\0';
				}

				rval = server->GetHackProfileString(configname2,"global","bindpathkey");
				if(strlen(rval)) {
					globalConfig.bindpathkey = rval;
					rval = server->GetHackProfileString(configname2,"global","bindpathnpc");
					if(strlen(rval)) {
						globalConfig.bindpathnpc = rval;
						sprintf(DebugBuffer, "bind set %s 00 say .shopbot loadpath %s",globalConfig.bindpathkey,globalConfig.bindpathnpc);
						server->GameCommandLine(DebugBuffer);
					}
				}
			}

			WPSTRUCT *wp;
			rval = server->GetHackProfileString(configname2,"global","townwp");
			if(strlen(rval)) {
				wp = getWPbyName(rval);
				if(wp == NULL) {
					sprintf(DebugBuffer,"c1:: c4ShopBotc1 :: c0Invalid townwp waypoint name '%s'",rval);
					server->GamePrintString(DebugBuffer);
					globalConfig.townWP.wpNum = 0;
				} else {
					if(!wp->isTown) {
						server->GamePrintString("c1:: c4ShopBotc1 :: c0townwp waypoint must be a town!");
						globalConfig.townWP.wpNum = 0;
					} else {
						memcpy(&globalConfig.townWP,wp,sizeof(WPSTRUCT));
					}
				}
			} else {
				globalConfig.townWP.wpNum = 0;
			}

			rval = server->GetHackProfileString(configname2,"global","otherwp");
			if(strlen(rval)) {
				wp = getWPbyName(rval);
				if(wp == NULL) {
					sprintf(DebugBuffer,"c1:: c4ShopBotc1 :: c0Invalid otherwp waypoint name '%s'",rval);
					server->GamePrintString(DebugBuffer);
					globalConfig.otherWP.wpNum = 0;
				} else {
						memcpy(&globalConfig.otherWP,wp,sizeof(WPSTRUCT));
				}
			} else {
				globalConfig.otherWP.wpNum = 0;
			}

			rval = server->GetHackProfileString(configname2,"global","steptime");
			if(strlen(rval)) {
				globalConfig.steptime = atoi(rval);
			} else {
				globalConfig.steptime = 2;
			}

			
			if(globalConfig.townWP.wpNum == 0 || globalConfig.otherWP.wpNum == 0) {
				server->GamePrintString("c1:: c4ShopBotc1 :: c0You have invalid or non-existing intown/outtown global settings");
				return false;
			}
			goto NEXT;
		} 
		
		strcpy(cfg->Section,&Sections[counter]);
		counter = counter + strlen(&Sections[counter]) + 1;
		// now query the section and fill in data
		
		// ItemCode should be 3 or 4 chars long
		rval = server->GetHackProfileString(configname2, cfg->Section, "Code");
		if(strlen(rval)) {
			if(strlen(rval) != 4 && strlen(rval) != 3) {
				sprintf(error,"c1:: c4ShopBotc1 :: c0Bad Code value '%s' in section [%s], Skipping",rval,cfg->Section);
				server->GamePrintString(error);
				delete cfg;
				goto NEXT;
			}
			
			// if 4 char is a space, chop it off
			if(rval[3] == ' ') 
				rval[3] = '\0';

			strcpy(cfg->item.ItemCode,rval);
			// delete rval;
		} else {
			cfg->item.ItemCode[0] = '\0';
		}

		// Item Description
		rval = server->GetHackProfileString(configname2, cfg->Section, "Description");
		if(strlen(rval)) {
			if(strlen(rval) > 127) {
				sprintf(error,"c1:: c4ShopBotc1 :: c0Description too long in section [%s], Skipping",cfg->Section);
				server->GamePrintString(error);
				delete cfg;
				goto NEXT;
			}
			strcpy(cfg->Description,rval);
			// delete rval;
		} else {
			cfg->Description[0] = '\0';
		}

		// basename of item, aka itemname without a prefix or suffix
		rval = server->GetHackProfileString(configname2, cfg->Section, "BaseName");
		if(strlen(rval)) {
			if(strlen(rval) > 32) {
				sprintf(error,"c1:: c4ShopBotc1 :: c0BaseName too long in section [%s], Skipping",cfg->Section);
				server->GamePrintString(error);
				delete cfg;
				goto NEXT;
			}
			strcpy(cfg->BaseName,rval);
			// delete rval;
		} else {
			cfg->BaseName[0] = '\0';
		}

		rval = server->GetHackProfileString(configname2, cfg->Section, "MagicPrefix");
		if(strlen(rval)) {
			if(strlen(rval) > 32) {
				sprintf(error,"c1:: c4ShopBotc1 :: c0MagicPrefix too long in section [%s], Skipping",cfg->Section);
				server->GamePrintString(error);
				delete cfg;
				goto NEXT;
			}
			strcpy(cfg->MagicPrefix,rval);
			// delete rval;
		} else {
			cfg->MagicPrefix[0] = '\0';
		}

		rval = server->GetHackProfileString(configname2, cfg->Section, "MagicSuffix");
		if(strlen(rval)) {
			if(strlen(rval) > 32) {
				sprintf(error,"c1:: c4ShopBotc1 :: c0MagicSuffix too long in section [%s], Skipping",cfg->Section);
				server->GamePrintString(error);
				delete cfg;
				goto NEXT;
			}
			strcpy(cfg->MagicSuffix,rval);
			 // delete rval;
		} else {
			cfg->MagicSuffix[0] = '\0';
		}

		rval = server->GetHackProfileString(configname2, cfg->Section, "Category");
		if(strlen(rval)) {
			if(strlen(rval) > 8) {
				sprintf(error,"c1:: c4ShopBotc1 :: c0Category too long in section [%s], Skipping",cfg->Section);
				server->GamePrintString(error);
				delete cfg;
				goto NEXT;
			}
			strcpy(cfg->Category,rval);
			 // delete rval;
		} else {
			cfg->Category[0] = '\0';
		}
		rval = server->GetHackProfileString(configname2, cfg->Section, "Quality");
		if(strlen(rval)) {
			if(strlen(rval) > 12) {
				sprintf(error,"c1:: c4ShopBotc1 :: c0Quality too long in section [%s], Skipping",cfg->Section);
				server->GamePrintString(error);
				delete cfg;
				goto NEXT;
			}
			strcpy(cfg->Quality,rval);
			// delete rval;
		} else {
			strcpy(cfg->Quality,"normal");
		}

		rval = server->GetHackProfileString(configname2, cfg->Section, "Stop");
		if(strlen(rval)) {
			if (strcmpi(rval,"1") == 0)
				cfg->Stop = 1;
			else
				cfg->Stop = 0;
		} else {
			cfg->Stop = 0;
		}

		rval = server->GetHackProfileString(configname2, cfg->Section, "ED");
		if(strlen(rval)) {
			if(strlen(rval) > 3) {
				sprintf(error,"c1:: c4ShopBotc1 :: c0ED too long in section [%s], Skipping",cfg->Section);
				server->GamePrintString(error);
				delete cfg;
				goto NEXT;
			}
			strcpy(cfg->ED,rval);
			 // delete rval;
		} else {
			cfg->ED[0] = '\0';
		}

		rval = server->GetHackProfileString(configname2, cfg->Section, "Sockets");
		if(strlen(rval)) {
			if(strlen(rval) > 1) {
				sprintf(error,"c1:: c4ShopBotc1 :: c0Sockets too long in section [%s], Skipping",cfg->Section);
				server->GamePrintString(error);
				delete cfg;
				goto NEXT;
			}
			strcpy(cfg->Sockets,rval);
			// delete rval;
		} else {
			cfg->Sockets[0] = '\0';
		}
		

		// add to config linked list.
		config->AddItem(cfg);
	}
	return true;
}

CONFIGSTRUCT * ItemMatchCheck(ITEMSTRUCT *item) {
	LinkedItem_t *cfgItem;
	CONFIGSTRUCT *cfg;

	BOOL match;

		// write names to a file		
	if (globalConfig.itemsfile == true  && state != STATE_BROWSE){
		FILE *stream;
		char filename[1024];
		sprintf(filename, "%s\\shopbot\\items-all.txt", ConfigPath);
		stream = fopen(filename, "a");
		if (item->PrefixName[0]) {
			fprintf(stream, "%s %s %s\n",item->PrefixName,item->BaseName,item->SuffixName);
		} else {
			fprintf(stream, "%s %s\n",item->BaseName,item->SuffixName);
		}
		fclose(stream);
/*
		sprintf(filename, "%s\\shopbot\\shopbotitems2.txt", ConfigPath);
		stream = fopen(filename, "a");
		if (item->PrefixName[0]) {
			fprintf(stream, "%s|%s|%s|%s|%s\n",npc.name,item->weapon->Category,item->PrefixName,item->BaseName,item->SuffixName);
		} else {
			fprintf(stream, "%s|%s||%s|%s\n",npc.name,item->weapon->Category,item->BaseName,item->SuffixName);
		}
		fclose(stream);
*/	
	}
	
	for(cfgItem = config->GetFirstItem();cfgItem != NULL;cfgItem = config->GetNextItem(cfgItem)){
		match = true;
		cfg = (CONFIGSTRUCT*)cfgItem->lpData;


		if (cfg->Sockets[0] != '\0' && match){
			char tmp[1];
			sprintf(tmp,"%d",item->nSockets);
			if(strcmpi(cfg->Sockets,tmp) > 0) {
				match = false;
//				server->GamePrintString("Failed");

			}
		}


		if (cfg->Category[0] != '\0'){
			if (item->Category[0] != '\0'){
				if(strcmpi(cfg->Category,item->Category) != 0) {
					match = false;
				}
			}
		}

		if (cfg->ED[0] != '\0' && match){
			if (item->nEnhanDamage > 0){
				char tmp[10];
				char tmp2[10];
					sprintf(tmp2,"%d",item->nEnhanDamage);
				if (strlen(tmp2) == 3)
					sprintf(tmp,"%d",item->nEnhanDamage);
				else if (strlen(tmp2) == 2)
					sprintf(tmp,"0%d",item->nEnhanDamage);
				else if (strlen(tmp2) == 1)
					sprintf(tmp,"00%d",item->nEnhanDamage);
				if(strcmpi(cfg->ED,tmp) > 0) {
					match = false;
				}
				//sprintf(DebugBuffer, "%d %s",item->nEnhanDamage, cfg->ED);
				//server->GamePrintString(DebugBuffer);
			} else {
				match = false;
			}
		}
		if(cfg->item.ItemCode[0] != '\0' && strcmpi(cfg->item.ItemCode,item->ItemCode) != 0) 
			match = false;

		if(cfg->MagicPrefix[0] != '\0' && match) {
			if(item->PrefixName[0] != '\0') {
				if(strcmpi(cfg->MagicPrefix,item->PrefixName) != 0) {
					match = false;
				}
			} else {
				match = false;
			}
		}
		
		if(cfg->BaseName[0] != '\0' && match) {
			if(item->BaseName[0] != '\0') {
				if(strcmpi(cfg->BaseName,item->BaseName) != 0) {
					match = false;
				}
			} else {
				match = false;
			}
		}

		if(cfg->MagicSuffix[0] != '\0' && match) {
			if(item->SuffixName[0] != '\0') {
				if(strcmpi(cfg->MagicSuffix,item->SuffixName) != 0) {
					match = false;
				}
			} else {
				match = false;
			}
		}

		if (match){
			if(strcmpi(cfg->Quality,"exceptional") == 0) {
				if (strcmpi(item->weapon->Code,item->weapon->NormalCode) == 0){
					match = false;
				}
			}
			if(strcmpi(cfg->Quality,"elite") == 0) {
				if (strcmpi(item->weapon->Code,item->weapon->NormalCode) == 0){
					match = false;
				}
				if (strcmpi(item->weapon->Code,item->weapon->UberCode) == 0){
					match = false;
				}
			}
		}
		
		if(match) {
			if (globalConfig.boughtfile == true){
				if (item->PrefixName[0])
					sprintf(boughtitemname,"%s %s %s\n",item->PrefixName,item->BaseName,item->SuffixName);
				//	fprintf(stream, "%s %s %s\n",item->PrefixName,item->BaseName,item->SuffixName);
				else
					sprintf(boughtitemname,"%s %s\n",item->BaseName,item->SuffixName);
					//fprintf(stream, "%s %s\n",item->BaseName,item->SuffixName);
			}
			return cfg;
		}

	}
	return NULL;
}




// 
// stuff below here is from ClientCore.cpp
//////////////////////////////////////////////////////////////////////
// Dll entry/exit
//////////////////////////////////////////////////////////////////////
BOOL APIENTRY DllMain(HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	BOOL hResult = TRUE;
	char *t;
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			
			// Create server struct			
			server = new FUNCTIONENTRYPOINTS; 

			// Bind exported functions from server
			HMODULE hModule;
			hModule = (HMODULE)GetModuleHandle("D2HackIt");
			
			// Macros make this look a lot nicer :)
			BIND_TO_SERVER(GamePrintInfo);
			BIND_TO_SERVER(GamePrintError);
			BIND_TO_SERVER(GamePrintVerbose);
			BIND_TO_SERVER(GamePrintString);
			BIND_TO_SERVER(GameCommandLine);
			BIND_TO_SERVER(GameSendPacketToServer);
			BIND_TO_SERVER(GameSendPacketToGame);
			BIND_TO_SERVER(GetFingerprint);
			BIND_TO_SERVER(Intercept);
			BIND_TO_SERVER(GetHackProfileString);
			BIND_TO_SERVER(SetHackProfileString);
			BIND_TO_SERVER(GetThisgameStruct);

			// Get plugin path
			t = ConfigPath;
			if (GetModuleFileName((HINSTANCE)hModule, t, _MAX_PATH)) {
				int p=strlen(ConfigPath);
				while (p) {
						if (ConfigPath[p] == '\\')
							{ ConfigPath[p] = 0; p=0;}
						else
					p--;
				}
			}	 
			// initiate client
			// hResult = OnClientStart();
			break;

		case DLL_PROCESS_DETACH:
			// kill client

			// hResult = OnClientStop();

			delete server;
			break;
    } 
    return hResult;
}

//////////////////////////////////////////////////////////////////////
// Stubfunctions for 'property get' functions.
//////////////////////////////////////////////////////////////////////
LPCSTR	EXPORT GetModuleAuthor()		{return ModuleAuthor;}
LPCSTR	EXPORT GetModuleWebsite()		{return ModuleWebsite;}
DWORD	EXPORT GetModuleVersion()		{return ModuleVersion;}
LPCSTR	EXPORT GetModuleEmail()			{return ModuleEmail;}
LPCSTR	EXPORT GetModuleDescription()	{return ModuleDescription;}

//////////////////////////////////////////////////////////////////////
// OnClientCommandLine
// -------------------------------------------------------------------
// The modules own extension of the command line interface. Any custom
// commands you add are parsed here.
//
// Return value should be TRUE, but it is not used at this 
// time.
//
// Arguments when we get here:
// argv[0]			Name of module
// argv[1]			Name of command (If supplied)
// argv[2 ... n]	The rest
//
// Syntax in the game: .<module> <arguments>
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnGameCommandLine(char* argv[], int argc)
{
	// Check if user supplied anything at all, if not assume help...
	if (argc==1)
		argv[argc++]="help";


	MODULECOMMANDSTRUCT* mcs=ModuleCommands;

	while (mcs->szName) {
		if (!stricmp(mcs->szName, argv[1]))
			break;
		mcs++;
	}

	char *p,*t,*msg,*fMsg;
	fMsg=new char[256];
	//
	// Is this a built-in function ?
	if (mcs->szName) {
		//
		// If functions returns false, show usage help
		if (!mcs->pFunc(argv, argc)) {
			t=new char[strlen(mcs->szUsage)+1];
			server->GamePrintInfo("Usage:");
			sprintf((char*)t, "%s", mcs->szUsage);
			if (strlen((char*)t))
			{
				msg=p=t;
				while (*p != 0) {
					if (*p == '\n') 
					{
						*(p++) = 0;
						sprintf(fMsg, "c4.%s %s", argv[0], msg);
						server->GamePrintInfo((char*)fMsg);
					if (*p != 0)
						msg = p;
					} else
						p++;
					}
				sprintf(fMsg, "c4.%s %s", argv[0], msg);
				server->GamePrintInfo((char*)fMsg);
			}
			delete t;
		}
	} else {
	// Unknown command, show catch-all help phraze.
	t=new char[128];
	sprintf(t, "Unknown command c4'%s %s'c0 - try c4'.%s help'c0 to get help.",
		argv[0], argv[1], argv[0]);
	server->GamePrintError(t);
	delete t;
	}
	delete fMsg;
	return TRUE;
}


//////////////////////////////////////////////////////////////////////
// OnCommandHelp
// -------------------------------------------------------------------
// Our default help function.
//
// Syntax in the game: .<module> <arguments>
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnCommandHelp(char** argv, int argc)
{
	// If command line is longer than 2, show usage for 'help'
	if (argc>2) return FALSE;

	char t[1024];
	sprintf(t, "Available commands for %s:", argv[0]);
	server->GamePrintInfo(t);

	// Loop through ModuleCommands[] and print their names
	for (int i=0; ModuleCommands[i].szName != NULL; i++)
	{
		sprintf(t, "c4.%s %s", argv[0], ModuleCommands[i].szName);
		server->GamePrintInfo(t);
	}

	sprintf(t, "For help on a specific command, type c4.%s <command> help", argv[0]);
	server->GamePrintInfo(t);
	return TRUE;
}

